' Copyright (c) 2002 Extended Systems, Inc.  ALL RIGHTS RESERVED.
'
' SAMPLE CODE
'
' This sample code can be used, modified, or copied by the licensee as long as
' the modifications (or the new binary resulting from a copy or modification of
' this sample code) are used with Extended Systems' products. The sample code
' is not redistributable as sample code, but is redistributable as compiled
' and linked binary code. If the sample code is used, modified, or copied by
' the licensee, Extended Systems Inc. reserves the right to receive from the
' licensee, upon request, at no cost to Extended Systems Inc., the modifications.
'
' Extended Systems Inc. does not warrant that the operation of this software
' will meet your requirements or that the operation of the software will be
' uninterrupted, be error free, or that defects in software will be corrected.
' This software is provided "AS IS" without warranty of any kind. The entire
' risk as to the quality and performance of this software is with the purchaser.
' If this software proves defective or inadequate, purchaser assumes the entire
' cost of servicing or repair. No oral or written information or advice given
' by an Extended Systems Inc. representative shall create a warranty or in any
' way increase the scope of this warranty.

Imports System.Data.OleDb


Public Class StateInfo
   Public ConnID As Int32
   Public DataConnection As New OleDbConnection()
End Class


<ComClass(aep_procedures.ClassId, aep_procedures.InterfaceId, aep_procedures.EventsId)> _
Public Class aep_procedures

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class
    ' and its COM interfaces. If you change them, existing
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "16881E53-7654-45CC-8879-B3A352042D95"
    Public Const InterfaceId As String = "F0F14533-1E6D-4C60-AC81-A1F862CE5F27"
    Public Const EventsId As String = "CE85ED3A-CE1B-4195-9BC9-6FF0CECA4330"
#End Region

   ' A creatable COM class must have a Public Sub New()
   ' with no parameters, otherwise, the class will not be
   ' registered in the COM registry and cannot be created
   ' via CreateObject.
   Public Sub New()
       MyBase.New()
   End Sub

   ' Declare a collection of objects that can be used to store state information
   Private Shared colClientInfo As New Collection()


   ' This is the AEP startup function.  This is called the first time an Advantage
   ' connection calls a procedure in this AEP module. It is called once for each
   ' Advantage connection that calls a procedure in this module.
   ' Do any per-connection initialization here. Use the ulConnectionID as a
   ' unique identifier for each connection.
   Public Function Startup(ByVal ulConnectionID As Int32, _
                           ByVal strUsername As String, _
                           ByVal strPassword As String) As Int32   ' do not change prototype
      Dim oStateInfo As New StateInfo()

      Try

         ' Store the connection ID
         oStateInfo.ConnID = ulConnectionID

         ' Get a connection this client can use in all AEP calls to this dll. This is not required,
         ' it is simply shown as an example of something you might want to store on a per-client
         ' basis (state information).
         oStateInfo.DataConnection.ConnectionString = "Provider=Advantage.OLEDB.1;Data Source = x:\data\aep_tutorial.add" & _
                                          ";User ID=" & strUsername & ";Password=" & strPassword & ";StoredProcedureConnection=TRUE" & _
                                          ";ServerType=ADS_LOCAL_SERVER"
         oStateInfo.DataConnection.Open()

         ' Place this client state info into our collection. Use a synclock, as there might be other
         ' threads accessing colClientInfo right now
         SyncLock colClientInfo
         colClientInfo.Add(oStateInfo, CStr(ulConnectionID))
         End SyncLock

      Catch Ex As Exception
         Startup = 1
      End Try

      Startup = 0

   End Function


   ' This is the AEP shutdown function.  This is called once for each Advantage
   ' connection that has called a procedure in this module, and is called when
   ' the connection is terminating.
   ' The prototype must be exactly as it is in the example.
   ' Do your per-connection clean-up here. Use the ulConnectionID as a
   ' unique identifier for each connection.
   Public Function Shutdown(ByVal ulConnectionID As Int32, _
                            ByVal strUsername As String, _
                            ByVal strPassword As String) As Int32
      Dim oStateInfo As StateInfo

      ' Get this clients state information before doing anything
      SyncLock colClientInfo
      oStateInfo = colClientInfo.Item(CStr(ulConnectionID))
      End SyncLock

      oStateInfo.DataConnection.Close()

      ' free the clients state information
      SyncLock colClientInfo
      colClientInfo.Remove(CStr(ulConnectionID))
      End SyncLock

      Shutdown = 0

   End Function


   Private Function QuotedStr(ByVal s As String) As String
       Dim sChar As String
       Dim pos As Integer
       Dim opos As Integer

       sChar = "'"
       pos = InStr(1, s, sChar)

       If (pos = 0) Then
          QuotedStr = s
          Exit Function
       End If

       Do While (pos > 0)
          QuotedStr = QuotedStr & Mid(s, 1, pos) & sChar
          s = Mid(s, pos + 1)
          pos = InStr(1, s, sChar)
       Loop
       QuotedStr = QuotedStr & s
    End Function



   ' This is a sample Advantage Extended Procedure
   Public Function MyProcedure(ByVal ulConnectionID As Int32, _
                               ByVal strUsername As String, _
                               ByVal strPassword As String, _
                               ByVal strProcname As String, _
                               ByVal ulRecNum As Int32, _
                               ByVal strInput As String, _
                               ByVal strOutput As String) As Int32
   Dim ParamConn As OleDbConnection
   Dim GetCommand As OleDbCommand
   Dim DataAdapter As OleDbDataAdapter
   Dim InputTable As DataTable
   Dim OutputTable As OleDbCommand
   Dim strConnStr As String
   Dim strInputName As String
   Dim strOutputName As String
   Dim oStateInfo As StateInfo
   Dim sql As String
   Dim i As Int32
   Dim strManufacturer As String
   Dim strProduct As String
   Dim iQuantity As Int32
   Dim iQuantityOnHand As Int32
   Dim iNewOrderNum As Int32
   Dim ItemPrice As Double
   Dim myReader As OleDbDataReader

   Try

      ' Get this clients state information before doing anything
      SyncLock colClientInfo
      oStateInfo = colClientInfo.Item(CStr(ulConnectionID))
      End SyncLock

      ' create objects
      GetCommand = New OleDbCommand()
      DataAdapter = New OleDbDataAdapter()
      InputTable = New DataTable()

      ' MyProcedure is called with the following input parameters,
      ' which are automatically put in the table referenced by
      ' strTable1 for us by ADS:
      '    manufacturer
      '    product id
      '    quantity

      ' Split up the tablename and path
      i = InStrRev(strInput, "\")
      strConnStr = Left(strInput, i - 1)
      strInputName = Right(strInput, Len(strInput) - i)
      strOutputName = Right(strOutput, Len(strOutput) - i)

      ' Get a connection used to read the parameters
      ParamConn = New OleDbConnection("Provider=Advantage.OLEDB.1" & _
         ";Data Source = " & strConnStr & _
         ";StoredProcedureConnection=TRUE;ServerType=ADS_LOCAL_SERVER")
      ParamConn.Open()

      GetCommand.CommandType = CommandType.TableDirect
      GetCommand.CommandText = strInputName
      GetCommand.Connection = ParamConn
      DataAdapter.SelectCommand = GetCommand
      DataAdapter.Fill(InputTable)
      strManufacturer = InputTable.Rows(0).Item("mfr")
      strProduct = InputTable.Rows(0).Item("product")
      iQuantity = InputTable.Rows(0).Item("quantity")

      ' Now we have our input parameters, so let's get to work.
      GetCommand.Connection = oStateInfo.DataConnection
      GetCommand.CommandType = CommandType.Text
      GetCommand.CommandText = "SELECT * FROM products WHERE mfr_id = '" & _
         strManufacturer & "' AND product_id = '" & strProduct & "'"
      myReader = GetCommand.ExecuteReader

      ' Save the item price.
      myReader.Read()
      ItemPrice = myReader.GetDouble(3)
      ' And the number on hand.
      iQuantityOnHand = myReader.GetInt32(4)
      myReader.Close()

      ' Reduce the number on hand.
      GetCommand.CommandText = "UPDATE products SET qty_on_hand = " & _
         (iQuantityOnHand - iQuantity) & " WHERE mfr_id = '" & strManufacturer & _
            "' AND product_id = '" & strProduct & "'"
      GetCommand.ExecuteNonQuery()

      ' Add a new record to the orders table.
      ' NOTE : This is no where near multi-user safe (not checking for a
      ' lock failure). For the purpose of this example we will just use
      ' an order number one larger than the last order.
      GetCommand.CommandText = "SELECT MAX(order_num) FROM orders"
      iNewOrderNum = GetCommand.ExecuteScalar
      iNewOrderNum = iNewOrderNum + 1

      GetCommand.CommandText = "INSERT INTO orders (order_num, mfr, product, " & _
            "qty, amount) VALUES ( " & iNewOrderNum & ", '" & strManufacturer & _
            "', '" & strProduct & "', " & iQuantity & ", " & (iQuantity * ItemPrice) & " )"
      GetCommand.ExecuteNonQuery()

      ' MyProcedure returns the following output parameters, which are returned
      ' in the table referenced by pucTable2:
      '    order number
      '    total price
      sql = "INSERT INTO """ & strOutputName & """ VALUES( " & iNewOrderNum & _
            ", " & (iQuantity * ItemPrice) & ", '' )"
      OutputTable = New OleDbCommand(sql)
      OutputTable.Connection = ParamConn
      OutputTable.ExecuteNonQuery()

   Catch Ex As Exception
      ' Handle any exceptions here. It's best to have one string output
      ' parameter in each procedure that can be used to return a string
      ' representation of any errors encountered during stored procedure
      ' execution (using Ex.ToString)
      sql = "INSERT INTO """ & strOutputName & """ ( error_string ) VALUES ( '" & _
               QuotedStr(Ex.Message) & "' )"
      Dim ErrorOutputCommand As New OleDbCommand(sql)
      ErrorOutputCommand.Connection = ParamConn
      ErrorOutputCommand.ExecuteNonQuery()
      Return 0
   Finally
      ' Disconnect
      ParamConn.Close()
   End Try

   Return 0

End Function




End Class


